/*
 * Decompiled with CFR 0.152.
 */
package net.grhq.pastacountdown;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.grhq.pastacountdown.About;
import net.grhq.pastacountdown.SetTimer;

public class CountDown
extends JFrame
implements Runnable {
    int hours = 0;
    int min = 5;
    int sec = 0;
    int reset_hours = this.hours;
    int reset_min = this.min;
    int reset_sec = this.sec;
    boolean running = false;
    boolean alarm = false;
    private JLabel CountDownBoard;
    private JMenuItem aboutMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuItem freezeCount;
    private JMenu helpMenu;
    private JMenuBar menuBar;
    private JMenuItem resetTime;
    private JMenuItem setTime;
    private JMenuItem startCount;

    public CountDown() {
        this.initComponents();
    }

    private void initComponents() {
        this.CountDownBoard = new JLabel();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.setTime = new JMenuItem();
        this.resetTime = new JMenuItem();
        this.startCount = new JMenuItem();
        this.freezeCount = new JMenuItem();
        this.exitMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.setTitle("The Pasta CountDown Center");
        this.setFont(new Font("Dialog", 0, 18));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("pasta.jpg")));
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                CountDown.this.exitForm(evt);
            }
        });
        this.CountDownBoard.setFont(new Font("Dialog", 1, 48));
        this.CountDownBoard.setForeground(new Color(102, 0, 102));
        this.CountDownBoard.setHorizontalAlignment(0);
        this.CountDownBoard.setText(String.valueOf(this.fill2char(this.hours)) + ":" + this.fill2char(this.min) + ":" + this.fill2char(this.sec));
        this.CountDownBoard.setHorizontalTextPosition(0);
        this.getContentPane().add((Component)this.CountDownBoard, "North");
        this.fileMenu.setText("CountDown");
        this.fileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountDown.this.fileMenuActionPerformed(evt);
            }
        });
        this.setTime.setText("Set Time");
        this.setTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountDown.this.setTimeActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.setTime);
        this.resetTime.setText("Reset Time");
        this.resetTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountDown.this.resetTimeActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.resetTime);
        this.startCount.setText("Start Count");
        this.startCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountDown.this.startCountActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.startCount);
        this.freezeCount.setText("Freeze Count");
        this.freezeCount.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountDown.this.freezeCountActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.freezeCount);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountDown.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.helpMenu.setText("About");
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CountDown.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void resetTimeActionPerformed(ActionEvent evt) {
        this.alarm = false;
        this.hours = this.reset_hours;
        this.min = this.reset_min;
        this.sec = this.reset_sec;
        this.CountDownBoard.repaint(500L);
    }

    private void freezeCountActionPerformed(ActionEvent evt) {
        this.running = false;
    }

    private void startCountActionPerformed(ActionEvent evt) {
        this.running = true;
    }

    private void setTimeActionPerformed(ActionEvent evt) {
        SetTimer timer = new SetTimer((Frame)new JFrame(), true);
        timer.setLocationRelativeTo(this);
        timer.show();
        if (timer.getReturnStatus() == 1) {
            this.hours = this.reset_hours = timer.getHours();
            this.min = this.reset_min = timer.getMin();
            this.sec = this.reset_sec = timer.getSec();
        }
        this.alarm = false;
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        About a = new About((Frame)new JFrame(), true);
        a.setLocationRelativeTo(this);
        a.show();
    }

    private void fileMenuActionPerformed(ActionEvent evt) {
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public static void main(String[] args) {
        CountDown c = new CountDown();
        new Thread(c).start();
        c.setSize(350, 150);
        c.show();
    }

    public void run() {
        try {
            while (true) {
                Thread.sleep(1000L);
                this.CountDownBoard.setText(String.valueOf(this.fill2char(this.hours)) + ":" + this.fill2char(this.min) + ":" + this.fill2char(this.sec));
                this.CountDownBoard.repaint(500L);
                if (!this.alarm) {
                    this.CountDownBoard.setForeground(new Color(102, 0, 102));
                } else {
                    this.CountDownBoard.setForeground(new Color(255, 0, 0));
                    try {
                        Sequence sequence = MidiSystem.getSequence(this.getClass().getResource("dontcare.mid"));
                        Sequencer sequencer = MidiSystem.getSequencer();
                        sequencer.open();
                        sequencer.setSequence(sequence);
                        sequencer.start();
                        Thread.sleep(2000L);
                        sequencer.stop();
                        sequencer.close();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!this.running) continue;
                if (this.min == 0 && this.sec == 0 && this.hours == 0) {
                    this.running = false;
                    this.alarm = true;
                    continue;
                }
                if (this.sec == 0) {
                    this.sec = 59;
                    if (this.min == 0) {
                        this.min = 59;
                        --this.hours;
                        continue;
                    }
                    --this.min;
                    continue;
                }
                --this.sec;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    String fill2char(int a) {
        String s = "0" + Integer.toString(a);
        s = s.substring(s.length() - 2);
        return s;
    }
}

